#include <Struct.h>
#include <3DEngine.h>
#include <afxcmn.h>
#include "resource.h"

extern BOOL EasySelectEnabled;
extern BOOL EasySelectReady;
extern BOOL IsRectShape;
extern CToolBar* pBar;
DWORD  flags;
tPOINT  PressedAt;
POINT  loc;

extern HCURSOR  hcNorm,
        hcShift,
        hcCtrl,
        hcLBNorm,
        hcLBShift,
        hcLBCtrl;
extern HCURSOR  hcRNorm,
        hcRShift,
        hcRCtrl,
        hcCNorm,
        hcCShift,
        hcCCtrl;

void RestoreCursors(BOOL bForce = FALSE)
{
  if (bForce || (hcNorm != hArrowCursor))
    CurrentState.CurrentProcs.hcNorm  = hcNorm;
  if (bForce || (hcShift != hArrowCursor))
    CurrentState.CurrentProcs.hcShift  = hcShift;
  if (bForce || (hcCtrl != hArrowCursor))
    CurrentState.CurrentProcs.hcCtrl  = hcCtrl;
  if (bForce || (hcLBNorm != hArrowCursor))
    CurrentState.CurrentProcs.hcLBNorm  = hcLBNorm;
  if (bForce || (hcLBShift != hArrowCursor))
    CurrentState.CurrentProcs.hcLBShift  = hcLBShift;
  if (bForce || (hcLBCtrl != hArrowCursor))
    CurrentState.CurrentProcs.hcLBCtrl  = hcLBCtrl;
}    


BOOL IsPointInRect(POINT& p, POINT& one, POINT& two)
{
  return  ((p.x > one.x) && (p.x < two.x) || (p.x < one.x) && (p.x > two.x)) &&
          ((p.y > one.y) && (p.y < two.y) || (p.y < one.y) && (p.y > two.y));
}

BOOL IsPointInCirc(tNormalVertex* v, tPOINT* center, tPOINT* rad, z3dViewDescriptor* pView)
{
  POINT pv, pc;
  pv = ConvertToScreen(v->X, v->Y, v->Z, pView);
  pc = ConvertToScreen(center->x, center->y, center->z, pView);
  if ((rad->x < MINFLOAT) || (rad->y < MINFLOAT))
    return FALSE;

  return  (pc.x-pv.x)*(pc.x-pv.x)/(rad->x*rad->x) + 
          (pc.y-pv.y)*(pc.y-pv.y)/(rad->y*rad->y) < 1.0f;
}


void ProcessSelection(
            tObject* obj,
            UINT nFlags,
            tPOINT *min,    // or center.
            tPOINT *max,    // or radiuses
            z3dViewDescriptor* pView,
            BOOL CrossingEnough,
            WORD ShapeType) // 0 - rect, 1-circle
{
  BOOL SelectResult = !CrossingEnough; //??? not sure!
  
  if (CurrentState.IsLevel(Z3D_LEVEL_OBJECTS) && !obj->AllowGenericEdit())
    return;
  if (!CurrentState.IsLevel(Z3D_LEVEL_OBJECTS) && !obj->AllowLowLevelEdit())
    return;
  if ((pView->Kind == Z3D_VIEWMODE_MAPPER) != (0==strcmp(obj->ObjectName, "UVMapperDATA")))
    return;

  if ((CurrentState.IsLevel(Z3D_LEVEL_VERTICES) || CurrentState.IsLevel(Z3D_LEVEL_FACES) || CurrentState.IsLevel(Z3D_LEVEL_EDGES))
    && !obj->Marked())
    return;

  POINT p1,p2,p3;
  POINT pmin, pmax;
  tNormalVertex v;
  pmin = ConvertToScreen(min->x, min->y, min->z, pView);
  pmax = ConvertToScreen(max->x, max->y, max->z, pView);


  //////////// Rect Selection /////////////////
  if (ShapeType==0)
  {
    if (CurrentState.IsLevel(Z3D_LEVEL_OBJECTS) || (CurrentState.nCurrentViewFlags & Z3D_VIEWFLAG_SEETHROUGH))
    {//check see through
      if (CurrentState.IsLevel(Z3D_LEVEL_OBJECTS) || CurrentState.IsLevel(Z3D_LEVEL_VERTICES) || CurrentState.IsLevel(Z3D_LEVEL_EDGES))
      for (  VertCount=0;
        VertCount < obj->VertTable->VertAmount;
        VertCount++)
      {//for
        obj->VertTable->Table[VertCount].UnMark();
        if (pView->Kind == Z3D_VIEWMODE_USER)
        {
          p1 = ConvertToScreen( obj->VertTable->Table[VertCount].X,
                                obj->VertTable->Table[VertCount].Y,
                                obj->VertTable->Table[VertCount].Z,
                                pView);
          if (IsPointInRect(p1, pmin, pmax))
          {
            obj->VertTable->Table[VertCount].Mark();
            SelectResult = TRUE;
          }
        }
        else
        {
          if (obj->VertTable->Table[VertCount].InRectRegion(min, max, CrossingEnough))
          {
            obj->VertTable->Table[VertCount].Mark();
            SelectResult = TRUE;
          }
        }
      }//for
      if (CurrentState.IsLevel(Z3D_LEVEL_FACES))
      for (  FaceCount=0; FaceCount < obj->FaceTable->FaceAmount; FaceCount++)
      {//for
        obj->FaceTable->Table[FaceCount].UnMark();
        v.X = fdivide(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].X + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].X + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].X,3);
        v.Y = fdivide(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Y + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Y + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Y,3);
        v.Z = fdivide(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Z + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Z + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Z,3);
        p1 = ConvertToScreen( v.X,
                              v.Y,
                              v.Z,
                              pView);
        if (((pView->Kind == Z3D_VIEWMODE_USER) && (IsPointInRect(p1, pmin, pmax)) ||
            (pView->Kind != Z3D_VIEWMODE_USER) && v.InRectRegion(min, max, CrossingEnough)))
        {
          obj->FaceTable->Table[FaceCount].Mark();
          SelectResult = TRUE;
        }
      }//for
    }//check see through
    else
    {
      for (  FaceCount=0; FaceCount < obj->FaceTable->FaceAmount; FaceCount++)
      {//for
        p1 = ConvertToScreen(  obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].X,
                    obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Y,
                    obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Z,
                    pView);
        p2 = ConvertToScreen(  obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].X,
                    obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Y,
                    obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Z,
                    pView);
        p3 = ConvertToScreen(  obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].X,
                    obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Y,
                    obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Z,
                    pView);
        if (IsFaceVisible(p1,p2,p3))
        {//ok-visible
          if (CurrentState.IsLevel(Z3D_LEVEL_FACES))
          {
            obj->FaceTable->Table[FaceCount].UnMark();
            v.X = fdivide(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].X + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].X + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].X,3);
            v.Y = fdivide(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Y + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Y + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Y,3);
            v.Z = fdivide(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Z + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Z + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Z,3);
            p1 = ConvertToScreen( v.X,
                                  v.Y,
                                  v.Z,
                                  pView);
            if (((pView->Kind == Z3D_VIEWMODE_USER) && (IsPointInRect(p1, pmin, pmax)) ||
                (pView->Kind != Z3D_VIEWMODE_USER) && v.InRectRegion(min, max, CrossingEnough)))
            {
              obj->FaceTable->Table[FaceCount].Mark();
              SelectResult = TRUE;
            }
          }
          if (CurrentState.IsLevel(Z3D_LEVEL_OBJECTS) || CurrentState.IsLevel(Z3D_LEVEL_VERTICES) || CurrentState.IsLevel(Z3D_LEVEL_EDGES))
          {
            obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].UnMark();
            obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].UnMark();
            obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].UnMark();
            if (pView->Kind == Z3D_VIEWMODE_USER)
            {
              p1 = ConvertToScreen( obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].X,
                                    obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Y,
                                    obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Z,
                                    pView);
              if (IsPointInRect(p1, pmin, pmax))
              {
                obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Mark();
                SelectResult = TRUE;
              }
            }
            else
              if (obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].InRectRegion(min, max, CrossingEnough))
              {
                obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Mark();
                SelectResult = TRUE;
              }
            if (pView->Kind == Z3D_VIEWMODE_USER)
            {
              p1 = ConvertToScreen( obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].X,
                                    obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Y,
                                    obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Z,
                                    pView);
              if (IsPointInRect(p1, pmin, pmax))
              {
                obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Mark();
                SelectResult = TRUE;
              }
            }
            else
              if (obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].InRectRegion(min, max, CrossingEnough))
              {
                obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Mark();
                SelectResult = TRUE;
              }
            if (pView->Kind == Z3D_VIEWMODE_USER)
            {
              p1 = ConvertToScreen( obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].X,
                                    obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Y,
                                    obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Z,
                                    pView);
              if (IsPointInRect(p1, pmin, pmax))
              {
                obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Mark();
                SelectResult = TRUE;
              }
            }
            else
              if (obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].InRectRegion(min, max, CrossingEnough))
              {
                obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Mark();
                SelectResult = TRUE;
              }
          }
        }//ok-visible
      }//for
    }//seethrough mode
  }//quadr

  ////////////// Circ Selection /////////////////
  if (ShapeType==1)
  {
    if (CurrentState.IsLevel(Z3D_LEVEL_OBJECTS) || (CurrentState.nCurrentViewFlags & Z3D_VIEWFLAG_SEETHROUGH))
    {//check see through
      if (CurrentState.IsLevel(Z3D_LEVEL_OBJECTS) || CurrentState.IsLevel(Z3D_LEVEL_VERTICES) || CurrentState.IsLevel(Z3D_LEVEL_EDGES))
      for (  VertCount=0;
        VertCount < obj->VertTable->VertAmount;
        VertCount++)
      {//for
        obj->VertTable->Table[VertCount].UnMark();
        if (pView->Kind == Z3D_VIEWMODE_USER)
        {
          if (IsPointInCirc(&obj->VertTable->Table[VertCount], min, max, pView))
          {
            obj->VertTable->Table[VertCount].Mark();
            SelectResult = TRUE;
          }
        }
        else
        {
          if (obj->VertTable->Table[VertCount].InCircRegion(min, &max->x, &max->y, &max->z, CrossingEnough))
          {
            obj->VertTable->Table[VertCount].Mark();
            SelectResult = TRUE;
          }
        }

      }//for
      if (CurrentState.IsLevel(Z3D_LEVEL_FACES))
      for (  FaceCount=0; FaceCount < obj->FaceTable->FaceAmount; FaceCount++)
      {//for
        obj->FaceTable->Table[FaceCount].UnMark();
        v.X = fdivide(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].X + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].X + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].X,3);
        v.Y = fdivide(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Y + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Y + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Y,3);
        v.Z = fdivide(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Z + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Z + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Z,3);
        if ((pView->Kind == Z3D_VIEWMODE_USER) && IsPointInCirc(&v, min, max, pView) ||
            (pView->Kind != Z3D_VIEWMODE_USER) && v.InCircRegion(min, &max->x, &max->y, &max->z, CrossingEnough))
        {
          obj->FaceTable->Table[FaceCount].Mark();
          SelectResult = TRUE;
        }
      }//for
    }//check see through
    else
    {
      for (  FaceCount=0; FaceCount < obj->FaceTable->FaceAmount; FaceCount++)
      {//for
        p1 = ConvertToScreen(  obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].X,
                    obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Y,
                    obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Z,
                    pView);
        p2 = ConvertToScreen(  obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].X,
                    obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Y,
                    obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Z,
                    pView);
        p3 = ConvertToScreen(  obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].X,
                    obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Y,
                    obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Z,
                    pView);
        if (IsFaceVisible(p1,p2,p3))
        {//ok-visible
          if (CurrentState.IsLevel(Z3D_LEVEL_FACES))
          {
            obj->FaceTable->Table[FaceCount].UnMark();
            v.X = fdivide(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].X + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].X + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].X,3);
            v.Y = fdivide(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Y + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Y + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Y,3);
            v.Z = fdivide(obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Z + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Z + obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Z,3);
            if ((pView->Kind == Z3D_VIEWMODE_USER) && IsPointInCirc(&v, min, max, pView) ||
                (pView->Kind != Z3D_VIEWMODE_USER) && v.InCircRegion(min, &max->x, &max->y, &max->z, CrossingEnough))
            {
              obj->FaceTable->Table[FaceCount].Mark();
              SelectResult = TRUE;
            }
          }
          if (CurrentState.IsLevel(Z3D_LEVEL_OBJECTS) || CurrentState.IsLevel(Z3D_LEVEL_VERTICES) || CurrentState.IsLevel(Z3D_LEVEL_EDGES))
          {
            obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].UnMark();
            obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].UnMark();
            obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].UnMark();
            if ((pView->Kind == Z3D_VIEWMODE_USER) && IsPointInCirc(&obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1], min, max, pView) ||
                (pView->Kind != Z3D_VIEWMODE_USER) && obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].InCircRegion(min, &max->x, &max->y, &max->z, CrossingEnough))
            {
              obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I1].Mark();
              SelectResult = TRUE;
            }
            if ((pView->Kind == Z3D_VIEWMODE_USER) && IsPointInCirc(&obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2], min, max, pView) ||
                (pView->Kind != Z3D_VIEWMODE_USER) && obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].InCircRegion(min, &max->x, &max->y, &max->z, CrossingEnough))
            {
              obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I2].Mark();
              SelectResult = TRUE;
            }
            if ((pView->Kind == Z3D_VIEWMODE_USER) && IsPointInCirc(&obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3], min, max, pView) ||
                (pView->Kind != Z3D_VIEWMODE_USER) && obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].InCircRegion(min, &max->x, &max->y, &max->z, CrossingEnough))
            {
              obj->VertTable->Table[obj->FaceTable->Table[FaceCount].I3].Mark();
              SelectResult = TRUE;
            }
          }
        }//ok-visible
      }//for
    }//seethrough mode
  }//circ

  ///////////// Selection processing: Add/Remove //////////////
  if (SelectResult)
  {//valid selection
    if ((CurrentState.IsLevel(Z3D_LEVEL_VERTICES) || CurrentState.IsLevel(Z3D_LEVEL_EDGES)) && !((nFlags & MK_CONTROL) == MK_CONTROL))
    {
      for (
          VertCount=0;
          VertCount < obj->VertTable->VertAmount;
          VertCount++)
      obj->VertTable->Table[VertCount].ToHasFlagSetFlag(  TRUE, FALSE, FALSE, FALSE,
                                FALSE, FALSE, TRUE, TRUE,
                                TRUE, TRUE, FALSE, FALSE);
    }
    if (CurrentState.IsLevel(Z3D_LEVEL_FACES) && !((nFlags & MK_CONTROL) == MK_CONTROL))
    {
      for (  FaceCount=0;
          FaceCount < obj->FaceTable->FaceAmount;
          FaceCount++)
      obj->FaceTable->Table[FaceCount].ToHasFlagSetFlag(  TRUE, FALSE, FALSE, FALSE,
                                FALSE, FALSE, TRUE, TRUE,
                                TRUE, TRUE, FALSE, FALSE);
    }
    if (((nFlags & MK_CONTROL)==MK_CONTROL) && (CurrentState.IsLevel(Z3D_LEVEL_VERTICES) || CurrentState.IsLevel(Z3D_LEVEL_EDGES)))
    {
      for (  VertCount=0;
          VertCount < obj->VertTable->VertAmount;
          VertCount++)
      obj->VertTable->Table[VertCount].ToHasFlagSetFlag(  TRUE, FALSE, FALSE, FALSE,
                                FALSE, FALSE, TRUE, TRUE,
                                FALSE, FALSE, FALSE, FALSE);
    }
    if (((nFlags & MK_CONTROL)==MK_CONTROL) && CurrentState.IsLevel(Z3D_LEVEL_FACES))
    {
      for (  FaceCount=0;
          FaceCount < obj->FaceTable->FaceAmount;
          FaceCount++)
      obj->FaceTable->Table[FaceCount].ToHasFlagSetFlag(  TRUE, FALSE, FALSE, FALSE,
                                FALSE, FALSE, TRUE, TRUE,
                                FALSE, FALSE, FALSE, FALSE);
    }
    if (CurrentState.IsLevel(Z3D_LEVEL_OBJECTS))
    {
      if (!CrossingEnough)
        for (  VertCount=0;
            VertCount < obj->VertTable->VertAmount && SelectResult;
            VertCount++)
        SelectResult = obj->VertTable->Table[VertCount].Marked();
      if (SelectResult)
      {
        if ((nFlags & MK_CONTROL)==MK_CONTROL)
          {obj->UnSelect();obj->VertTable->UnSelectAll();}
        else/// + shift or nothing pressed additional.////
          {obj->Select(); obj->VertTable->SelectAll();}
      }
    }
  }
  obj->VertTable->UnMarkAll();
  obj->FaceTable->UnMarkAll();
  obj->nRequire = Z3D_PLUGRESULT_UPDATEWIRE;
}//selector


DWORD CALLBACK EasySelectOnMouseMove(tProcParams* params)
{
  if (!EasySelectEnabled || IsAlternateMode()) return 0;
  //this function verifies whether selectino shape have
  //to be drawen. It discards farther processing...

  //the shape will be drawen if:
  // 1) nothing is marked.
  // 2) something is marked, but it's not selected.
  BOOL bFoundMarkedAndNotSelected = FALSE;
  BOOL bSomethingIsMarked = FALSE;
  flags = *params->nFlags;
  PressedAt = *params->ProcessedLocation;
  loc  = *params->loc;

  for (ObjCount = 0; (ObjCount < params->Objects->ObjAmount) && !bFoundMarkedAndNotSelected; ObjCount++)
    if (CurrentState.IsLevel(Z3D_LEVEL_OBJECTS) &&
      params->Objects->Marked(ObjCount))
    {
      bSomethingIsMarked = TRUE;
      if (!params->Objects->Selected(ObjCount))
        bFoundMarkedAndNotSelected = TRUE;
    }
    else
    if ((CurrentState.IsLevel(Z3D_LEVEL_VERTICES) || CurrentState.IsLevel(Z3D_LEVEL_EDGES))
      && params->Objects->Marked(ObjCount))
    {
      for (VertCount = 0; (VertCount < params->Objects->ObjSet[ObjCount].VertTable->VertAmount) && !bFoundMarkedAndNotSelected; VertCount++)
        if (params->Objects->ObjSet[ObjCount].VertTable->Marked(VertCount))
        {
          bSomethingIsMarked = TRUE;
          if (!params->Objects->ObjSet[ObjCount].VertTable->Selected(VertCount))
            bFoundMarkedAndNotSelected = TRUE;
        }
    }
    else
    if (CurrentState.IsLevel(Z3D_LEVEL_FACES) && params->Objects->Marked(ObjCount))
    {
      for (FaceCount = 0; (FaceCount < params->Objects->ObjSet[ObjCount].FaceTable->FaceAmount) && !bFoundMarkedAndNotSelected; FaceCount++)
        if (params->Objects->ObjSet[ObjCount].FaceTable->Marked(FaceCount))
        {
          bSomethingIsMarked = TRUE;
          if (!params->Objects->ObjSet[ObjCount].FaceTable->Selected(FaceCount))
            bFoundMarkedAndNotSelected = TRUE;
        }
    }

  EasySelectReady = !bSomethingIsMarked ||
    (CurrentState.IsLevel(Z3D_LEVEL_FACES) && bFoundMarkedAndNotSelected);

  if (!EasySelectReady)
    RestoreCursors();
  else
  {
    if ((CurrentState.CurrentProcs.hcNorm != hcRNorm) && (CurrentState.CurrentProcs.hcNorm != hcCNorm))
      hcNorm = CurrentState.CurrentProcs.hcNorm;
    if ((CurrentState.CurrentProcs.hcShift != hcRShift) && (CurrentState.CurrentProcs.hcShift != hcCShift))
      hcNorm = CurrentState.CurrentProcs.hcShift;
    if ((CurrentState.CurrentProcs.hcCtrl != hcRCtrl) && (CurrentState.CurrentProcs.hcCtrl != hcCCtrl))
      hcNorm = CurrentState.CurrentProcs.hcCtrl;
    if ((CurrentState.CurrentProcs.hcLBNorm != hcRNorm) && (CurrentState.CurrentProcs.hcLBNorm != hcCNorm))
      hcNorm = CurrentState.CurrentProcs.hcLBNorm;
    if ((CurrentState.CurrentProcs.hcLBShift != hcRShift) && (CurrentState.CurrentProcs.hcLBShift != hcCShift))
      hcNorm = CurrentState.CurrentProcs.hcLBShift;
    if ((CurrentState.CurrentProcs.hcLBCtrl != hcRCtrl) && (CurrentState.CurrentProcs.hcLBCtrl != hcCCtrl))
      hcNorm = CurrentState.CurrentProcs.hcLBCtrl;

    CurrentState.CurrentProcs.hcLBNorm  = CurrentState.CurrentProcs.hcNorm  = IsRectShape ? hcRNorm : hcCNorm;
    CurrentState.CurrentProcs.hcLBShift  = CurrentState.CurrentProcs.hcShift  = IsRectShape ? hcRShift : hcCShift;
    CurrentState.CurrentProcs.hcLBCtrl  = CurrentState.CurrentProcs.hcCtrl  = IsRectShape ? hcRCtrl : hcCCtrl;
  }
  return 
    Z3D_PLUGRESULT_CURSORCHANGE;
}


DWORD CALLBACK EasySelectOnLButtonDown(tProcParams* params)
{
  if (!EasySelectEnabled || !EasySelectReady || IsAlternateMode())
    return 0;
  flags = *params->nFlags;
  return EasySelectReady ? Z3D_PLUGRESULT_STOPPROCESS : 0;
}


DWORD CALLBACK EasySelectOnMouseMoveLBD(tProcParams* params)
{
  if (!EasySelectEnabled || !EasySelectReady || IsAlternateMode())
    return 0;

  if (IsRectShape)
  {//rectangle dragmode
    POINT lp;
    tPOINT LPnew = ConvertFromScreen(
      params->loc->x,
      params->loc->y,
      params->ViewDesc);
    lp = ConvertToScreen(  params->LastPressedAt->x,
                params->LastPressedAt->y,
                params->LastPressedAt->z,
                params->ViewDesc);
    params->pdc->SelectObject((CPen*)Global.PenThinBlueCreate);
    params->pdc->SelectStockObject(NULL_BRUSH);
    params->pdc->Rectangle(lp.x, lp.y, params->loc->x, params->loc->y);
    params->pdc->SelectObject((CPen*)Global.PenThinBlack);
    params->LastMovedAt->x = LPnew.x;
    params->LastMovedAt->y = LPnew.y;
    params->LastMovedAt->z = LPnew.z;
  }
  else
  {//CIRCLE
    POINT radiusnew;//.radiusold;
    POINT lp;
    tPOINT LPnew = ConvertFromScreen(
      params->loc->x,
      params->loc->y,
      params->ViewDesc);
    lp = ConvertToScreen(  params->LastPressedAt->x,
                params->LastPressedAt->y,
                params->LastPressedAt->z,
                params->ViewDesc);
    params->pdc->SelectStockObject(NULL_BRUSH);
    params->pdc->SelectObject((CPen*)Global.PenThinBlueCreate);
    radiusnew.x = (long)sqrt(sqr(lp.x - params->loc->x));
    radiusnew.y = (long)sqrt(sqr(lp.y - params->loc->y));
    params->pdc->Ellipse( lp.x-radiusnew.x , lp.y-radiusnew.y , lp.x+radiusnew.x , lp.y+radiusnew.y);
    params->pdc->SelectObject((CPen*)Global.PenThinBlack);
    params->LastMovedAt->x = LPnew.x;
    params->LastMovedAt->y = LPnew.y;
    params->LastMovedAt->z = LPnew.z;
  }

  return Z3D_PLUGRESULT_STOPPROCESS | Z3D_PLUGRESULT_MANUALDRAW;
}


DWORD CALLBACK EasySelectOnLButtonUp(tProcParams* params)
{
  if (!EasySelectEnabled || !EasySelectReady || IsAlternateMode())
    return 0;

  if (CurrentState.IsLevel(Z3D_LEVEL_SPLINES) ||
    CurrentState.IsLevel(Z3D_LEVEL_SPLINEVERTICES) ||
    CurrentState.IsLevel(Z3D_LEVEL_NONE) ||
    CurrentState.IsLevel(Z3D_LEVEL_NORMALS))
    return 0;
  if (ScreenDist(loc.x, loc.y, params->loc->x, params->loc->y) < 4)
  {//selection should not be performed...
    DWORD result = 0;
    z3dProcsSet* procs = IsAlternateMode() ? &CurrentState.AlternateProcs :
      &CurrentState.CurrentProcs;

    DWORD  curflags = *params->nFlags;
    tPOINT  curPressedAt = *params->ProcessedLocation;
    POINT  curloc = *params->loc;

    *params->nFlags = flags;
    *params->ProcessedLocation = PressedAt;
    *params->loc = loc;

    if (procs->OnLBDProc)
      result |= procs->OnLBDProc(params);
    if (procs->OnLBUProc)
      result |= procs->OnLBUProc(params);

    *params->nFlags = curflags;
    *params->ProcessedLocation = curPressedAt;
    *params->loc = curloc;
    return result;
  }


  if (IsAlternateMode())
    return 0;
  //////////////////////////////////////////
  // using standart flags backup function
  /////////////////////////////////////////
  if (CurrentState.UndoMaxSteps > 0)  
    Backup(Z3D_BACKUP_FLAGS, "Selection", FALSE, params);

  if (0 == ((*params->nFlags) & (MK_SHIFT | MK_CONTROL)))
  {//deselect
    for (ObjCount = 0; ObjCount < params->Objects->ObjAmount; ObjCount++)
    if (CurrentState.IsLevel(Z3D_LEVEL_OBJECTS))
      params->Objects->UnSelect(ObjCount);
    else
    if ((CurrentState.IsLevel(Z3D_LEVEL_VERTICES) || CurrentState.IsLevel(Z3D_LEVEL_EDGES))
      && params->Objects->Marked(ObjCount))
      params->Objects->ObjSet[ObjCount].VertTable->UnSelectAll();
    else
    if (CurrentState.IsLevel(Z3D_LEVEL_FACES) && params->Objects->Marked(ObjCount))
      params->Objects->ObjSet[ObjCount].FaceTable->UnSelectAll();
  }


  if (IsRectShape)
  {
    tPOINT start;
    tPOINT end;
    tPOINT Screen1,Screen2;
    POINT lp = ConvertToScreen(
            params->LastPressedAt->x,
            params->LastPressedAt->y,
            params->LastPressedAt->z,
            params->ViewDesc);
    Screen1 = ConvertFromScreen(lp.x, lp.y, params->ViewDesc);
    Screen2 = ConvertFromScreen(params->loc->x, params->loc->y, params->ViewDesc);
    start.x = minimum(Screen1.x, Screen2.x);
    start.y = minimum(Screen1.y, Screen2.y);
    start.z = minimum(Screen1.z, Screen2.z);
    end.x = maximum(Screen1.x, Screen2.x);
    end.y = maximum(Screen1.y, Screen2.y);
    end.z = maximum(Screen1.z, Screen2.z);
    if (IsTop(params->ViewDesc->Kind)) {start.y = -MAXFLOAT;end.y = MAXFLOAT;}
    if (IsSide(params->ViewDesc->Kind)){start.x = -MAXFLOAT;end.x = MAXFLOAT;}
    if (IsFrontal(params->ViewDesc->Kind) ||
        (params->ViewDesc->Kind==Z3D_VIEWMODE_MAPPER)) {start.z = -MAXFLOAT;end.z = MAXFLOAT;}
    if (params->ViewDesc->Kind==Z3D_VIEWMODE_USER)
    {
      start = Screen1;
      end = Screen2;
    }
    for (ObjCount = 0; ObjCount < params->Objects->ObjAmount; ObjCount++)
    {
      ProcessSelection(&params->Objects->ObjSet[ObjCount], *params->nFlags, &start, &end,
        params->ViewDesc, FALSE, 0); //0 is quadr
    }
  }
  else
  {
    ////////////////////////
    //  SELECTION  CIRCLE
    ////////////////////////
    tPOINT radius;
    float radiusx, radiusy;
    POINT lp = ConvertToScreen(
            params->LastPressedAt->x,
            params->LastPressedAt->y,
            params->LastPressedAt->z,
            params->ViewDesc);

    tPOINT Center = ConvertFromScreen(lp.x, lp.y, params->ViewDesc);

    if (params->ViewDesc->Kind==Z3D_VIEWMODE_USER)
    {
      radiusx = (float)fabs(lp.x-params->loc->x);
      radiusy = (float)fabs(lp.y-params->loc->y);
    }
    else
    {
      radiusx = (float)fabs(fdivide(lp.x-params->loc->x, params->ViewDesc->Zoom));
      radiusy = (float)fabs(fdivide(lp.y-params->loc->y, params->ViewDesc->Zoom));
    }

    if (IsTop(params->ViewDesc->Kind)) {radius.x = radiusx; radius.z = radiusy; radius.y = MAXFLOAT;}
    if (IsSide(params->ViewDesc->Kind)) {radius.z = radiusx; radius.y = radiusy; radius.x = MAXFLOAT;}
    if (IsFrontal(params->ViewDesc->Kind) ||
        (params->ViewDesc->Kind==Z3D_VIEWMODE_MAPPER) ||
        (params->ViewDesc->Kind==Z3D_VIEWMODE_USER))
    {radius.x = radiusx; radius.y = radiusy; radius.z = MAXFLOAT;}
    for (ObjCount = 0; ObjCount < params->Objects->ObjAmount; ObjCount++)
    {
      ProcessSelection(&params->Objects->ObjSet[ObjCount], *params->nFlags, &Center, &radius,
        params->ViewDesc, FALSE, 1);//1 is circle
    }
  }  

  BOOL bSomethingIsSelected = FALSE;

  for (ObjCount = 0; (ObjCount < params->Objects->ObjAmount) && !bSomethingIsSelected; ObjCount++)
    if (CurrentState.IsLevel(Z3D_LEVEL_OBJECTS) &&
      params->Objects->Selected(ObjCount))
      bSomethingIsSelected = TRUE;
    else
    if ((CurrentState.IsLevel(Z3D_LEVEL_VERTICES) || CurrentState.IsLevel(Z3D_LEVEL_EDGES))
      && params->Objects->Marked(ObjCount))
    {
      for (VertCount = 0; (VertCount < params->Objects->ObjSet[ObjCount].VertTable->VertAmount) && !bSomethingIsSelected; VertCount++)
        if (params->Objects->ObjSet[ObjCount].VertTable->Selected(VertCount))
          bSomethingIsSelected = TRUE;
    }
    else
    if (CurrentState.IsLevel(Z3D_LEVEL_FACES) && params->Objects->Marked(ObjCount))
    {
      for (FaceCount = 0; (FaceCount < params->Objects->ObjSet[ObjCount].FaceTable->FaceAmount) && !bSomethingIsSelected; FaceCount++)
        if (params->Objects->ObjSet[ObjCount].FaceTable->Selected(FaceCount))
          bSomethingIsSelected = TRUE;
    }
  //selected mode buttons:
  if (bSomethingIsSelected != CurrentState.IsSelectedMode())
    CurrentState.SwitchMode(Z3D_MODE_SELECTED);
  params->sysp(Z3D_REQUEST_PUSHMODESBUTTONS, NULL, NULL, NULL, NULL);

  return Z3D_PLUGRESULT_STOPPROCESS | Z3D_PLUGRESULT_VIEWSREDRAW |
     Z3D_PLUGRESULT_SELECTIONCHANGED;
}



DWORD CALLBACK RectOnPreMode(tProcParams* params)
{
  if (!params || !params->ListSet) return 0;
  if (EasySelectEnabled)
  {
    //disable circ button
    (pBar->GetToolBarCtrl()).CheckButton(ID_CIRCBUTTON, FALSE);
    IsRectShape = TRUE;
    return 0;
  }
  EasySelectEnabled = TRUE;
  IsRectShape = TRUE;
// add handlers
  params->ListSet->AddProc(
    Z3D_EVENT_MM,
    "Easy Selector",
    NULL,
    (PLUGPROCESSORPROC)GetProcAddress(params->DllHandle, "EasySelectOnMouseMove"),
    NULL,
    NULL,
    params,
    params->DllHandle);
  params->ListSet->AddProc(
    Z3D_EVENT_LBD,
    "Easy Selector",
    (PLUGPROCESSORPROC)GetProcAddress(params->DllHandle, "EasySelectOnLButtonDown"),
    NULL,
    NULL,
    NULL,
    params,
    params->DllHandle);
  params->ListSet->AddProc(
    Z3D_EVENT_MMLBD,
    "Easy Selector",
    (PLUGPROCESSORPROC)GetProcAddress(params->DllHandle, "EasySelectOnMouseMoveLBD"),
    NULL,
    NULL,
    NULL,
    params,
    params->DllHandle);
  params->ListSet->AddProc(
    Z3D_EVENT_LBU,
    "Easy Selector",
    (PLUGPROCESSORPROC)GetProcAddress(params->DllHandle, "EasySelectOnLButtonUp"),
    NULL,
    NULL,
    NULL,
    params,
    params->DllHandle);
  return 0;
}

DWORD CALLBACK CircOnPreMode(tProcParams* params)
{
  if (!params || !params->ListSet) return 0;
  if (EasySelectEnabled)
  {
    //disable rect button
    (pBar->GetToolBarCtrl()).CheckButton(ID_RECTBUTTON, FALSE);
    IsRectShape = FALSE;
    return 0;
  }
  EasySelectEnabled = TRUE;
  IsRectShape = FALSE;
// add handlers
  params->ListSet->AddProc(
    Z3D_EVENT_MM,
    "Easy Selector",
    NULL,
    (PLUGPROCESSORPROC)GetProcAddress(params->DllHandle, "EasySelectOnMouseMove"),
    NULL,
    NULL,
    params,
    params->DllHandle);
  params->ListSet->AddProc(
    Z3D_EVENT_LBD,
    "Easy Selector",
    (PLUGPROCESSORPROC)GetProcAddress(params->DllHandle, "EasySelectOnLButtonDown"),
    NULL,
    NULL,
    NULL,
    params,
    params->DllHandle);
  params->ListSet->AddProc(
    Z3D_EVENT_MMLBD,
    "Easy Selector",
    (PLUGPROCESSORPROC)GetProcAddress(params->DllHandle, "EasySelectOnMouseMoveLBD"),
    NULL,
    NULL,
    NULL,
    params,
    params->DllHandle);
  params->ListSet->AddProc(
    Z3D_EVENT_LBU,
    "Easy Selector",
    (PLUGPROCESSORPROC)GetProcAddress(params->DllHandle, "EasySelectOnLButtonUp"),
    NULL,
    NULL,
    NULL,
    params,
    params->DllHandle);
  return 0;
}


DWORD CALLBACK RectOnPostMode(tProcParams* params)
{
  if (!EasySelectEnabled)
    return 0;
  // remove handlers
  if (params && params->ListSet)
    params->ListSet->RemoveProc(
    Z3D_EVENT_LBD | Z3D_EVENT_MMLBD | Z3D_EVENT_LBU | Z3D_EVENT_MM,
    "Easy Selector", params);
  EasySelectEnabled = FALSE;
  RestoreCursors(TRUE);
  return 0;
}


DWORD CALLBACK CircOnPostMode(tProcParams* params)
{
  if (!EasySelectEnabled)
    return 0;
  // remove handlers
  if (params && params->ListSet)
    params->ListSet->RemoveProc(
    Z3D_EVENT_LBD | Z3D_EVENT_MMLBD | Z3D_EVENT_LBU | Z3D_EVENT_MM,
    "Easy Selector", params);
  EasySelectEnabled = FALSE;
  RestoreCursors(TRUE);
  return 0;
}


